/**
 *-----------------------------------------------------------------------------------
 *    Filename: ADFInitTermSystem.c
 *-----------------------------------------------------------------------------------
 *-----------------------------------------------------------------------------------
 *    Copyright 2004-2007 Mitsubishi Electric Research Laboratories (MERL)
 *    An implementation for initializing and terminating the Saffron type system
 *    Ronald Perry and Sarah Frisken
 *-----------------------------------------------------------------------------------
 */


/**
 *-----------------------------------------------------------------------------------
 *    Required include files for this implementation
 *-----------------------------------------------------------------------------------
 */
#include <stdlib.h>
#include "fs_object.h"
#include "fs_function.h"

#include "adfinittermsystem.h"


/**
 *-----------------------------------------------------------------------------------
 *    START: iType Edge Technology
 *-----------------------------------------------------------------------------------
 */
#ifdef FS_EDGE_TECH

/**
 *-----------------------------------------------------------------------------------
 *    The instance data structure used to record all global and static state for the 
 *    rendering system
 *-----------------------------------------------------------------------------------
 */
typedef struct {
    void *appInst;
}    ADFLibInst;


/**
 *-----------------------------------------------------------------------------------
 *    Initialize the ADF font rendering system. This call must precede all other
 *    ADFxxx() invocations. This function returns an opaque pointer to an 'instance'
 *    data structure which records all the global and static state for the rendering 
 *    system. A NULL is returned if the request cannot be satisfied.
 *
 *    All memory allocation tasks required by this system are performed via a set of 
 *    memory allocation macros; each macro requires appInst as an input argument (for
 *    a discussion of appInst, see the Memory Allocation section in the API (i.e., in 
 *    ADFTypeSystem.h)). If the default memory allocation macro definitions are used, 
 *    appInst is ignored.
 *-----------------------------------------------------------------------------------
 */
ADF_Void *ADFInitSystem (void *appInst)
{
    ADFLibInst *libInst;
#ifdef FS_MEM_DBG
    ((FS_STATE *)appInst)->memdbgid = "ADFLibInst";
#endif
    libInst = (ADFLibInst *) ADF_ALLOC(appInst, sizeof(ADFLibInst));
    if (libInst) 
        libInst->appInst = appInst;
    else
        ((FS_STATE *)appInst)->error = ERR_MALLOC_FAIL;
    return(libInst);
}


/**
 *-----------------------------------------------------------------------------------
 *    Terminate the ADF font rendering system. This function must be invoked when no
 *    further ADFxxx() invocations are required. The instance pointer returned by the
 *    corresponding ADFInitSystem() invocation is expected as input.
 *-----------------------------------------------------------------------------------
 */
ADF_Void ADFTermSystem (void *libInst)
{
    if (libInst) {
        void *appInst = ((ADFLibInst *)libInst)->appInst;
        ADF_FREE(appInst, libInst);
    }
}


/**
 *-----------------------------------------------------------------------------------
 *    Return the application instance (appInst) specified by the application when the
 *    ADF font rendering system was initialized (i.e., when ADFInitSystem() was 
 *    invoked)
 *-----------------------------------------------------------------------------------
 */
ADF_Void *ADFGetAppInst (void *libInst)
{
    if (libInst) return(((ADFLibInst *)libInst)->appInst);
    else return(0);
}

/**
 *-----------------------------------------------------------------------------------
 *    END: iType Edge Technology
 *-----------------------------------------------------------------------------------
 */
#endif
